/**
 * jQuery 1.2.6 Mouseover Scrolling v1.0 by Willin Kan
 * URI: http://kan.willin.org/
 * Original Code: http://kan.willin.org/click_or_mouseover_scrolling_test.html
 * Date: 2010-9-19
 * Install: Just adding javascript to webpage without more HTML change.
 * Notice: Need to add jQuery 1.2.6(above) first.
 */

jQuery.noConflict();

jQuery(document).ready(function($) {

$('body').append('<div id="scrollbar"><div id="up">&#9650;<\/div>&#9737;<div id="dn">&#9660;<\/div><\/div>'); // append div

$('#up').mouseover(function(){ up();            // scroll up
      }).mouseout(function(){ clearTimeout(fq); // stop
      }).click(function(){
         if (getY() == 0) return;               // reach top
         $('#scrollbar').fadeOut(function(){ self.scrollTo(0, 0); $('#scrollbar').fadeIn(); }) // jump up
      });

$('#dn').mouseover(function(){ dn();            // scroll dowm
      }).mouseout(function(){ clearTimeout(fq); // stop
      }).click(function(){
         if (getY() + document.documentElement.clientHeight >= document.body.offsetHeight) return; // reach bottom
         $('#scrollbar').fadeOut(function(){ self.scrollTo(0, document.body.offsetHeight); $('#scrollbar').fadeIn(); }) // jump dowm
      });

}); // end jQ

function getY(){
   posY = typeof(window.pageYOffset) == 'number' ? window.pageYOffset : document.documentElement.scrollTop; // current position
   return posY;
}

function up(){
   $area = jQuery(window);
   $area.scrollTop($area.scrollTop() - 20); // steps = -40
   fq = setTimeout("up()", 5);             // frequency
}

function dn(){
   $area = jQuery(window);
   $area.scrollTop($area.scrollTop() + 20); // steps = +40
   fq = setTimeout("dn()", 5);             // frequency
}

/* CSS */
bs = 'box-shadow: rgba(0,0,0,.3) 1px 5px 11px;';
br = 'border-radius: 17px;'; // round corner
document.write('<style type="text\/css">'
   + '#scrollbar {position:fixed; top:'       // ("position:fixed" not works in IE6, but I don't care.)
   + (document.documentElement.clientHeight * 0.73)       // 24% window height  
   + 'px; right:6px; height:74px; width:16px; padding:10px; font:15px/25px Arial; cursor:default;'
   + '-moz-'+ bs +'-webkit-'+ bs + bs                     // box-shadow
   + '-moz-'+ br +'-webkit-'+ br + br +'}'                // border-radius
   + '#up:hover, #dn:hover {cursor:pointer; color:#bbb;}' // hover color
   + '<\/style>');
// -- END ----------------------------------------