<?php
if ( function_exists('register_sidebar') )
register_sidebar(array('name'=>'Post Sidebar',
'before_widget' => '<div class="widgetblock">',
'after_widget' => '</div>',
'before_title' => '<h3>',
'after_title' => '</h3>',
));
?>
<?php
if ( function_exists('register_sidebar') )
register_sidebar(array('name'=>'Page Sidebar',
'before_widget' => '<div class="widgetblock">',
'after_widget' => '</div>',
'before_title' => '<h3>',
'after_title' => '</h3>',
));
?>
<?php
load_theme_textdomain('revoffice');

class RevolutionOffice {

	function addOptions () {

		if (isset($_POST['revoffice_reset'])) { RevolutionOffice::initOptions(true); }

		if (isset($_POST['revoffice_save'])) {

			$aOptions = RevolutionOffice::initOptions(false);
			$aOptions['featured-cat'] = $_POST['featured-cat'];
			$aOptions['column1-id'] = $_POST['column1-id'];		
			$aOptions['column2-id'] = $_POST['column2-id'];
			$aOptions['column3-id'] = $_POST['column3-id'];
			$aOptions['homebox-id'] = $_POST['homebox-id'];
			$aOptions['footer-text'] = stripslashes($_POST['footer-text']);
			update_option('revoffice_theme', $aOptions);

		}
		
		add_theme_page("Revolution Office Theme Options", "Revolution Office Options", 'edit_themes', basename(__FILE__), array('RevolutionOffice', 'displayOptions'));
	}
	
	function initOptions ($bReset) {
		$aOptions = get_option('revoffice_theme');
		if (!is_array($aOptions) || $bReset) {
			$aOptions['featured-cat'] = '3';
			$aOptions['column1-id'] = '1';
			$aOptions['column2-id'] = '1';
			$aOptions['column3-id'] = '1';
			$aOptions['homebox-id'] = '3';
			$aOptions['footer-text'] = 'Copyright 2008 SomeSite.com - All Rights Reserved';
			update_option('revoffice_theme', $aOptions);
		}
		return $aOptions;
	}

	function displayOptions () {
		$aOptions = RevolutionOffice::initOptions(false);
?>

<div class="wrap">
	<h2>Revolution Office Theme Options</h2>	
    <div style="margin-left:0px;">
    <form action="#" method="post" enctype="multipart/form-data" name="massive_form" id="massive_form">
		<fieldset name="general_options" class="options">
		
        <h3 style="margin-bottom:0px;">Home Page "Featured Content Carousel" Options</h3>        
        <p style="margin-top:0px;">Use the field below to edit the category you wish to use for the featured content carousel. The featured content carousel is found at the top of the home page template.</p>
		
        Featured Category ID Number: (You can easily find your category ID number using the "<a href="http://wordpress.org/extend/plugins/reveal-ids-for-wp-admin-25/" title="Reveal ID's" target="_blank">Reveal ID's</a>" Plugin)<br />
		<div style="margin:0;padding:0;">
        <input name="featured-cat" id="featured-cat" value="<?php echo($aOptions['featured-cat']); ?>" size="2" ></input>   
        </div><br /> 

        <h3 style="margin-bottom:0px;">Home Page "Column Text" Options:</h3>
        <p style="margin-top:0px;">Use the fields below to edit the 3 specific posts you would like to be displayed within the 3 main columns on the home page. You can change these posts at any time.</p>
 
        Column #1 Post ID#:<br />
		<div style="margin:0;padding:0;">
        <input name="column1-id" id="column1-id" value="<?php echo($aOptions['column1-id']); ?>" size="2" ></input>   
        </div><br /> 
        
        Column #2 Post ID#:<br />
        <div style="margin:0;padding:0;">
        <input name="column2-id" id="column2-id" value="<?php echo($aOptions['column2-id']); ?>" size="2" ></input> 
        </div><br />
        
        Column #3 Post ID#:<br />
		<div style="margin:0;padding:0;">
        <input name="column3-id" id="column3-id" value="<?php echo($aOptions['column3-id']); ?>" size="2" ></input>  
        </div><br />
        
        <h3 style="margin-bottom:0px;">Home Page "Featured Box" Options:</h3>
        <p style="margin-top:0px;">Use the field below to select the category you wish to use do display posts within the "Featured Box" found at the very bottom of the home page.</p>
 
        Featured Box Category ID#:<br />
		<div style="margin:0;padding:0;">
        <input name="homebox-id" id="homebox-id" value="<?php echo($aOptions['homebox-id']); ?>" size="2" ></input>   
        </div><br /> 
        
        <h3 style="margin-bottom:0px;">Footer Copyright Text Options:</h3>
        <p style="margin-top:0px;">Use the field below to edit your copyright text within the footer.</p>
        
        Footer Text:<br />
        <div style="margin:0;padding:0;">
        <input name="footer-text" id="footer-text" size="75" value="<?php echo($aOptions['footer-text']); ?>"></input> 
        </div><br />
                                
		</fieldset>
		<p class="submit"><input type="submit" name="revoffice_reset" value="Reset" /></p>
		<p class="submit"><input type="submit" name="revoffice_save" value="Save" /></p>
	</form>      
</div>
<?php
	}
}

// Register functions
add_action('admin_menu', array('RevolutionOffice', 'addOptions'));

?>