<?php get_header(); ?>

<?php
$aOptions = SofaiBloggr::initOptions( false );
$pagetag = ( strlen( $aOptions[ 'pagetag' ] ) > 0 ) ? stripslashes( $aOptions[ 'pagetag' ] ) : 'Page';
?>

<div id="articles" class="section">
 <?php if( is_category() ) { ?>
				<h2 class="sectionheader"><?php single_cat_title(); ?></h2>
 				<?php } elseif( is_tag() ) { ?>
				<h2 class="sectionheader">Tagged with "<?php single_tag_title(); ?>"</h2>
 				<?php } elseif( is_day() ) { ?>
				<h2 class="sectionheader">Archive: <?php the_time( 'F jS, Y' ); ?></h2>
 				<?php } elseif( is_month() ) { ?>
				<h2 class="sectionheader">Archive: <?php the_time( 'F, Y' ); ?></h2>
				<?php } elseif( is_year() ) { ?>
				<h2 class="sectionheader">Archive: <?php the_time( 'Y' ); ?></h2>
				<?php } elseif( is_author() ) { ?>
				<h2 class="sectionheader">Author Archive</h2>
 				<?php } elseif( isset($_GET[ 'paged' ] ) && !empty( $_GET[ 'paged' ] ) ) { ?>
				<h2 class="sectionheader"><?php bloginfo( 'name' ); ?> Archives</h2>
 		   <?php } ?>
           <?php 
		   if( have_posts()) : 
           echo '<ol class="post-list">';
		   ?>
		  

                   <?php while( have_posts() ) : the_post(); ?>
                       
                    <li>
                        <div class="postinfo">
                            <?php
							if( $post->post_type == 'post' ) {
							?>
                            <span class="date"><?php the_time( 'M j, Y' ); ?></span>
                            |
                            <span class="category"><a href="/category"><?php the_category( ', ' ); ?></a></span>
                
                            <span class="comments-count"><?php comments_number( '0', '1', '%' ); ?></span>
                            <?php
							} else {
                            ?>
                            <span class="date"><?php echo $pagetag; ?></span>
                            <?php
							}
							?>
                        </div>
                        <h3><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h3>
                    </li>
                       
                   <?php 
				   endwhile; 
				   echo '</ol>';
				   else : 
				   ?>
                   
					<p>No articles in database!</p>
                    
           		   <?php endif; ?>

<div id="pagination">
<?php 
    if( $wp_query->max_num_pages > 1 ) {
        // paging
        include( "wp-pagenavi.php" );
        if( function_exists( 'wp_pagenavi' ) ) { wp_pagenavi(); }
    } 
?>
</div><!-- pagination end -->

</div><!-- // articles end -->

<?php if ( !function_exists( 'dynamic_sidebar' ) || !dynamic_sidebar( 'Footer Archive' ) ) : ?>
<?php endif; ?>
           
<?php get_footer(); ?>