<?php
/*
Template Name: Contact
*/
?>

<?php get_header(); ?>

<?php  
$t_id = 0;
global $current_user;
get_currentuserinfo(); 

$aOptions = SofaiBloggr::initOptions( false );
$nametag = ( strlen( $nametag ) > 0 ) ? stripslashes( $nametag ) : "Your name";
$emailtag = ( strlen( $emailtag ) > 0 ) ? stripslashes( $emailtag ) : "E-mail address";
$webtag = ( strlen( $webtag ) > 0 ) ? stripslashes( $webtag ) : "WEB site";
$phonetag = ( strlen( $phonetag ) > 0 ) ? stripslashes( $phonetag ) : "Phone/Cell";
$commenttag = ( strlen( $commenttag ) > 0 ) ? stripslashes( $commenttag ) : "Comment";
$submittag = ( strlen( $submittag ) > 0 ) ? stripslashes( $submittag ) : "SUBMIT";
$t_id = get_permalink( $post->ID );

while( have_posts() ) : the_post();
?>

<div id="article" class="section">
<h1><?php the_title(); ?></h1>
<?php the_content(); ?>
<!-- <?php trackback_rdf(); ?> -->

        <?php
		// form submitted
		if( isset( $_POST[ 'sib' ] ) && $_POST[ 'sib' ] == 'submitted' ) {
			$err_msg = '';
			// security error
			if( check_admin_referer( 'sibcontact' ) != 1 ) $err_msg .= "<h2>Security Error!</h2><p>- You do not have a permission to perform such action!</p>";
			// name
			if( isset( $_POST[ 'yourname' ] ) && strlen( $_POST[ 'yourname' ] ) < 3 ) $err_msg .= "<h2>Name Error!</h2><p>- Your Name can not contain less than 3 characters!</p>";
			// message
			if( isset( $_POST[ 'message' ] ) && strlen( $_POST[ 'message' ] ) < 10 ) $err_msg .= "<h2>Message Error!</h2><p>- Your Message can not contain less than 10 characters!</p>";
			// validate human
			$sum = (int)$_POST[ 'spam' ];
			$v_1 = $_POST[ 'v_1' ]; 
			$v_1 = str_replace( "sx", "", $v_1 );
			$v_2 = $_POST[ 'v_2' ]; 
			$v_2 = str_replace( "sy", "", $v_2 );
			$sum_now = (int)$v_1 + (int)$v_2;
			if( $sum != $sum_now ) $err_msg .= "<h2>Spam prevention Error!</h2><p>- Sum is not correct!</p>";
			// validate email
			if( !is_email( $_POST[ 'email' ] ) ) $err_msg .= "<h2>Email Error!</h2><p>- Unknown or incorrect e-mail address format!</p>";
			
			// test passed?
			if( $err_msg == "" ) {
				
					//Who do you want to be the recipient of the contact form
					$owner = get_userdata( 1 ); // to admin
					$to = $owner->user_email;
				
					//This file is responsible for sending the email, you shouldn't need to edit it beyond here.
				
					//User info (DO NOT EDIT!)
					$name = stripslashes( $_POST[ 'yourname' ] ); //sender's name
					$email = stripslashes( $_POST[ 'email' ] ); //sender's email
					$uurl = stripslashes( $_POST[ 'uurl' ] ); //sender's website
					$entrysocial = stripslashes( $_POST[ 'entrysocial' ] ); // whatever
				
					//The subject
					$subject = '[ WEB Form - ' . get_bloginfo( 'name' ) . ' ]'; //Subject will include your blogs title for easy recognition.
					$message = stripslashes( $_POST[ 'message' ] );
				
					//The message you will receive in your mailbox
					//Each parts are commented to help you understand what it does exaclty.
					//YOU DON'T NEED TO EDIT IT BELOW BUT IF YOU DO, DO IT WITH CAUTION!
					
					// create proper headers so non-ascii characters are displayed properly
					$headers = "Content-Type: text/plain; charset=utf-8; format=flowed\r\n"
					. "Content-Transfer-Encoding: 8bit\r\n"
					. "MIME-Version: 1.0\r\n"
					. "From: $email\r\n"
					. "Reply-To: $email\r\n"
					. "Return-Path: $email\r\n";
				
					$msg  = "From : $name\r\n";  //add sender's name to the message
					$msg .= "e-Mail : $email\r\n";  //add sender's email to the message
					$msg .= "Subject : $subject\r\n\n"; //add subject to the message (optional! It will be displayed in the header anyway)
					$msg .= "---Message---\r\n$message\r\n\n";  //the message itself
				
					//Extras: User info (Optional!)
					//Delete this part if you don't need it
					//Display user information such as Ip address and browsers information...
					$msg .= "---User information---\r\n"; //Title
					$msg .= "User IP : " . $_SERVER[ "REMOTE_ADDR" ] . "\r\n"; //Sender's IP
					$msg .= "User other contact : " . ( ( $entrysocial ) ? $entrysocial : 'Not available' ) . "\r\n"; //Sender's contact
				
					if ( @mail( $to, $subject, $msg, $headers ) ) {
						echo "<h2>Success!</h2><p>Thank you <b>$name</b>, your message is sent! We will get back to you as soon as possible.</p>";
					}
					else {
						echo "<h2>Summary:</h2><p>Sorry <b>$name</b>, sending your message failed. Try again later!</p>";
					} 
			} else {
				// test not passed
				echo "<p style='color: red;'>Your message is not delivered because of the following reason(s):</p>";
				echo $err_msg;
			}
		} else { 
		?>
					<form id="commentform" method="post" action="<?php echo $t_id; ?>">
                    <p style="display: none; margin: 0; padding: 0; line-height: 0; visibility: hidden;">
                    <?php wp_nonce_field( 'sibcontact' ); ?>
                    <?php
					$v_1 = rand( '1', '10' );
					$v_2 = rand( '1', '10' );
					?>
					<input type="hidden" name="v_1" value="sx<?php echo $v_1; ?>"/>
					<input type="hidden" name="v_2" value="sy<?php echo $v_2; ?>"/>
                    <input type="hidden" name="sib" id="sib" value="submitted"/>
                    <input type="hidden" value="" name="comment_post_ID"/>
                    </p>
						<div>
							<label for="yourname"><?php echo $nametag; ?></label>
							<input type="text" size="22" id="yourname" name="yourname" tabindex="1"/>
						</div>

						<div>
							<label for="email"><?php echo $emailtag; ?></label>
							<input type="text" size="22" id="email" name="email" tabindex="2"/>
						</div>
						<div>
							<label for="uurl"><?php echo $webtag; ?></label>
							<input type="text" size="22" id="uurl" name="uurl" tabindex="3"/>
						</div>
						<div>
							<label for="entrysocial"><?php echo $phonetag; ?></label>
							<input type="text" size="22" id="entrysocial" name="entrysocial" tabindex="4"/>
						</div>
						<div>
							<label for="message"><?php echo $commenttag; ?></label>
							<textarea rows="8" cols="25" id="message" name="message" tabindex="5"></textarea>
						</div>
                        <div class="short">
	                       <label for="spam"><?php echo ( $v_1 . ' + ' . $v_2 . ' = *' ); ?></label>
	                       <input type="text" name="spam" id="spam" size="3" value="" tabindex="6"/>
                        </div>
						<div class="submitMe">
							<button type="submit" id="submit" value="Submit" tabindex="7"><span><?php echo $submittag; ?></span></button>
						</div>
					</form>
        <?php
		}
		?>

</div><!-- // contact end -->

<?php endwhile; ?>

<?php if ( !function_exists( 'dynamic_sidebar' ) || !dynamic_sidebar( 'Footer Contact' ) ) : ?>
<?php endif; ?>

<?php get_footer(); ?>
		   