<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <script src="<?php echo( bloginfo( 'template_directory' ) . '/js/jquery-1.3.2.min.js' ); ?>" type="text/javascript"></script>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta name="description" content="<?php bloginfo('description'); ?>" />
	<meta name="keywords" content="<?php bloginfo('name'); ?>" />
	<meta name="author" content="<?php bloginfo('name'); ?>" />
	<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" />
    <meta name="viewport" content="initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
	<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen, projection" />
	<!--[if lte IE 7]>
	<link rel="stylesheet" href="<?php echo( bloginfo( 'template_directory' ) . '/ie-style.css' ); ?>" type="text/css" media="screen, projection" />
	<![endif]-->
	<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
    <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon" />
	<title><?php bloginfo('name'); ?> <?php wp_title('-'); ?></title>
	<?php wp_head(); ?>
    <?php
		$aOptions = SofaiBloggr::initOptions( false );
		$usebread = $aOptions[ 'usebread' ];
		$navigate_site = ( strlen( $aOptions[ 'navigate_site' ] ) > 0 ) ? stripslashes( $aOptions[ 'navigate_site' ] ) : 'Navigate';
		$home_link = ( strlen( $aOptions[ 'home_link' ] ) > 0 ) ? stripslashes( $aOptions[ 'home_link' ] ) : 'Home';
		$searchtitle = ( strlen( $aOptions[ 'searchtitle' ] ) > 0 ) ? stripslashes( $aOptions[ 'searchtitle' ] ) : 'Search the site';
		$you_here = ( strlen( $aOptions[ 'you_here' ] ) > 0 ) ? stripslashes( $aOptions[ 'you_here' ] ) : 'You are here: ';
	?>
</head>

<body class="portrait">

	<div id="wrap">
    
		<div id="header">
        
			<div id="branding">
				<h1 class="logo">
                	<a href="<?php echo get_option( 'home' ); ?>" title="<?php bloginfo( 'name') ; ?>">
                		<img src="<?php echo bloginfo( 'template_directory' ) . ( '/images/iBloggr_logo.png' ); ?>" alt="<?php bloginfo( 'name' ); ?>" />
                    </a>
                </h1>
                <h2 class="tagline"><?php bloginfo( 'description' ); ?></h2>
			</div><!-- // branding end -->
            
			<?php if( is_home() ) { ?>
            <div id="intro">
				<img src="<?php echo bloginfo( 'template_directory' ) . ( '/images/intro.jpg' ); ?>" alt="<?php bloginfo( 'name') ; ?>" />
			</div><!-- // intro end -->
            <?php } ?>
            
            
            
            
			<div id="navigation">
                <a href="#" id="incnav"><?php echo $navigate_site; ?></a>
			</div><!-- // neavigation end -->
            
                <div id="navigate" class="section">
                    <div class="nav">
                        <ul id="globalnav">
                            <li<?php if ( is_home() ) echo ' class="current_page_item"'; ?>>
                                <a href="<?php echo get_option( 'home' ); ?>" title="<?php bloginfo( 'name') ; ?>"><?php echo $home_link; ?></a>
                            </li>
                            <?php wp_list_pages( 'title_li=&depth=0' ); ?>
                    		<?php wp_list_categories( 'title_li=&depth=0' ); ?>
                		</ul><!-- // neavigation end -->
                    </div><!-- // nav end -->      
                    
                    <div id="search">
                        <h1><?php echo $searchtitle; ?></h1>
                        <form id="searchform" method="get" action="<?php bloginfo( 'url' ); ?>">
                            <div>
                                <label for="s">Search term</label>
                                <input type="input" name="s" id="s" value="<?php the_search_query(); ?>" />
                            </div>
                            <div class="submitMe">
                                <button type="submit">Search</button>
                            </div>
                        </form>
                    </div><!-- // search end -->
                    
                    <div id="breadcrumbs">
                        <h1><?php echo $you_here; ?></h1>
						<?php
                            
                        if( $usebread == 'yes' ) {
                            $sepa_rator = '&raquo;';
                            $home_string = $home_link;
                            
                            // start div
                            echo '<div class="path">';
                            // home page icon
                            echo '<a href="';
                            echo get_option( 'home' );
                            echo '">';
                            echo $home_string;
                            echo '</a> ' . $sepa_rator . ' ';
                            
                            // is category?
                            if( is_category() ) {
                                // is root or sub-categ?
                                $curr_categ_object = get_category( get_query_var( 'cat' ), false );
                                $str_all_categ_props = get_category_parents( (int)$curr_categ_object->cat_ID, TRUE, '', FALSE );
                                $arr_all_categ_props = preg_match_all( '|<a.*?href=[\'"](.*?)[\'"].*?>(.*?)<.*?a>|i', $str_all_categ_props, $match_patern );
                                if( $arr_all_categ_props > 0 ) {
                                    $count_all_categ_props = 0;
                                    while( $count_all_categ_props < $arr_all_categ_props ) {
                                        if( ( $count_all_categ_props + 1 ) < $arr_all_categ_props ) 
                                        echo '<a href="' . $match_patern[ 1 ][ $count_all_categ_props ] . '" title="' . $match_patern[ 2 ][ $count_all_categ_props ] . '">' . $match_patern[ 2 ][ $count_all_categ_props ] . '</a> ' . $sepa_rator;
                                        else echo ' ' . $match_patern[ 2 ][ $count_all_categ_props ];
                                        $count_all_categ_props ++;
                                    }
                                }
                            } else if( is_single() ) {
                                // post details?
                                $curr_categ_object = get_the_category( $post->ID );
                                $str_all_categ_props = get_category_parents( $curr_categ_object[ 0 ]->cat_ID, TRUE, '', FALSE );
                                $arr_all_categ_props = preg_match_all( '|<a.*?href=[\'"](.*?)[\'"].*?>(.*?)<.*?a>|i', $str_all_categ_props, $match_patern );
                                if( $arr_all_categ_props > 0 ) {
                                    $count_all_categ_props = 0;
                                    while( $count_all_categ_props < $arr_all_categ_props ) {
                                        echo '<a href="' . $match_patern[ 1 ][ $count_all_categ_props ] . '" title="' . $match_patern[ 2 ][ $count_all_categ_props ] . '">' . $match_patern[ 2 ][ $count_all_categ_props ] . '</a> ' . $sepa_rator . ' ';
                                        $count_all_categ_props ++;
                                    }
                                    echo ' ' . $post->post_title;
                                }
                            } else if( is_page() ) {
                                // handle pages and subpages
                                $curr_page_object = get_post( get_query_var( 'page' ), OBJECT );
                                $arr_page_object  = get_post_ancestors( $curr_page_object->ID );
                                if( count( $arr_page_object ) > 0 ) {
                                    $count_all_pages = 0;
                                    while( $count_all_pages < count( $arr_page_object ) ) {
                                        $curr_post_object = get_post( $arr_page_object[ $count_all_pages ] );
                                        $curr_post_perma  = get_permalink( $arr_page_object[ $count_all_pages ] );
                                        echo '<a href="' . $curr_post_perma . '" title="' . $curr_post_object->post_title . '">' . $curr_post_object->post_title . '</a> ' . $sepa_rator . ' ';
                                        $count_all_pages ++;
                                    }
                                }
                                echo $post->post_title;
                            } 
                            else if( is_tag() ) echo 'Tag "' . single_tag_title( '', FALSE ) . '"';
                            else if( is_search() ) echo 'Search';
                            else if( is_404() ) echo '404 - Error';
                            else if( is_archive() ) echo 'Archive';
                            else if( is_author() ) echo 'Author';
                            else if( is_page_template() ) echo $post->post_title;
                            
                            // end DIV holder
                            echo '</div>';
                            
                        	} // end if use bread
                            ?>
                    </div><!-- // breadcrumbs end -->
                
                </div><!-- // navigate end -->
                
                
                
            
		</div><!-- // header end -->
        
		<div id="content">